require("json")
local R = require "routes"

module("page", package.seeall)

function update(app, web, id)
	return app.page:update(u2w(id))
end

function init_time(app, web, id)
	local uri = web.uri
	local r = R("/app/?:controller?/?:action?/?:id?")
	local t = r:match(uri)
	local stat = app.page.stat
	stat:init_time(t.id)
	return "OK"
end

function push_back(app, web, id)
	local uri = web.uri
	local r = R("/app/?:controller?/?:action?/?:id?")
	local t = r:match(uri)
	if (t.id~= nil) then
		t.id = string.gsub(t.id, '<~1~>', '/')
		t.id = string.gsub(t.id, '<~2~>', '"')
		t.id = string.gsub(t.id, '<~3~>', '\\')
		t.id = string.gsub(t.id, '<~4~>', '+')
		t.id = string.gsub(t.id, '<~5~>', ' ')
	else
		t.id = ''
	end
	app.page:push_back(u2w(t.id))
	return "OK"
end

function pop_back(app, web, id)
	app.page:pop_back()
	return "OK"
end

function load(app, web, id)

	local file = nil
	local p = string.find(web.uri, '?param=')
	if (p ~= nil) then
		file = string.sub(web.uri, p + 7)
	end

	app:load(id, file)
	return "OK"
end

function finishLess(app, web, id)
	local dash = {}

	dash.type 	  = "finishLess"

	return json.encode(dash)
end

function pause(app, web, id)
	log('stat:pause()\n')
	local stat = app.page.stat
	stat:pause()
end

function resume(app, web, id)
	log('stat:resume()\n')
	local stat = app.page.stat
	stat:resume()
end

function dashboard(app, web, id)
	local stat = app.page.stat
	local dash = {}

	dash.type 	  = "dashboard"
	dash.accu     = stat:accu()*100
	dash.speed    = stat:speed()*60
	dash.progress = stat:progress()*100
	dash.word = stat:word()
	dash.time = stat:elapse()

	return json.encode(dash)
end

function nextch(app, web, id)
	local hint = {}

	hint.type = "nextch"
	hint.nextch  = w2u(app.page.less:nextch())
	if (hint.nextch == ' ') then
		hint.nextch = '%20'
	end
	return json.encode(hint)
end

function saveWrongWords(app, web, id)
	local file = nil
	local p = string.find(web.uri, '?param=')
	if (p ~= nil) then
		file = string.sub(web.uri, p + 7)
	end
	app.page.less:saveWrongWords(file)
	return "OK"
end

